Attribute VB_Name = "Module2"
Option Explicit

Private Declare Function SetWindowsHookEx Lib "user32" Alias "SetWindowsHookExA" (ByVal idHook As Long, ByVal lpfn As Long, ByVal hmod As Long, ByVal dwThreadId As Long) As Long
Private Declare Function UnhookWindowsHookEx Lib "user32" (ByVal hHook As Long) As Long
Private Declare Function CallNextHookEx Lib "user32" (ByVal hHook As Long, ByVal ncode As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)


Public Const WH_CALLWNDPROC = 4
Public Const WH_CALLWNDPROCRET = 12
Public Const WH_CBT = 5
Public Const WH_DEBUG = 9
Public Const WH_FOREGROUNDIDLE = 11
Public Const WH_GETMESSAGE = 3
Public Const WH_HARDWARE = 8
Public Const WH_JOURNALPLAYBACK = 1
Public Const WH_JOURNALRECORD = 0
Public Const WH_KEYBOARD = 2
Public Const WH_MAX = 11
Public Const WH_MIN = (-1)
Public Const WH_MOUSE = 7
Public Const WH_MSGFILTER = (-1)
Public Const WH_SHELL = 10
Public Const WH_SYSMSGFILTER = 6

Private Const HC_ACTION = 0
Private Const HC_GETNEXT = 1
Private Const HC_SKIP = 2
Private Const HC_NOREMOVE = 3
Private Const HC_NOREM = HC_NOREMOVE
Private Const HC_SYSMODALOFF = 5
Private Const HC_SYSMODALON = 4

Public Const HSHELL_WINDOWCREATED = 1
Public Const HSHELL_WINDOWDESTROYED = 2
Public Const HSHELL_ACTIVATESHELLWINDOW = 3
Public Const HSHELL_APPCOMMAND = 12   '???

' #if(WINVER >= 0x0400)
Public Const HSHELL_WINDOWACTIVATED = 4
Public Const HSHELL_GETMINRECT = 5
Public Const HSHELL_REDRAW = 6
Public Const HSHELL_TASKMAN = 7
Public Const HSHELL_LANGUAGE = 8

' #if(_WIN32_WINNT >= 0x0500)
Public Const HSHELL_ACCESSIBILITYSTATE = 11
Public Const ACCESS_STICKYKEYS = &H1
Public Const ACCESS_FILTERKEYS = &H2
Public Const ACCESS_MOUSEKEYS = &H3


Public Type DEBUGHOOKINFO
        hModuleHook As Long
        Reserved As Long
        lParam As Long
        wParam As Long
        code As Long
End Type

Public Type POINTAPI
        x As Long
        y As Long
End Type

Public Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Public Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type


Private hHook As Long
Private hHookDBG As Long

Public IsHooked As Boolean
Public IsDBGHooked As Boolean




'-----------------------------
' SET MESSAGE FILTER HOOK
'-----------------------------
Public Sub SetShellHook()
    If IsHooked Then
        MsgBox "Don't hook SHELL twice or you will be unable to unhook it."
    Else
        hHook = SetWindowsHookEx(WH_SHELL, AddressOf ShellProc, 0, App.ThreadID)
        IsHooked = True
    End If
End Sub

Public Sub RemoveShellHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hHook)
    IsHooked = False
End Sub


Public Function ShellProc(ByVal uCode As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Dim structWindowSize As RECT
    
    Select Case uCode
        Case HSHELL_ACTIVATESHELLWINDOW
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_ACTIVATESHELLWINDOW" & vbNewLine
        Case HSHELL_WINDOWCREATED
            'wParam == Handle to the created window
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_WINDOWCREATED    hwnd:" & wParam & vbNewLine
        Case HSHELL_WINDOWDESTROYED
            'wParam == Handle to the destroyed window
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_WINDOWDESTROYED    hwnd:" & wParam & vbNewLine
        Case HSHELL_WINDOWACTIVATED
            'wParam == Handle to the activated window
            'lParam == The value is TRUE if the window is in full-screen mode, or FALSE otherwise
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_WINDOWACTIVATED    hwnd:" & wParam & "    Maximized:" & CBool(lParam) & vbNewLine
        Case HSHELL_GETMINRECT
            'wParam == Handle to the minimized or maximized window
            'lParam == Pointer to a RECT structure
            CopyMemory structWindowSize, lParam, Len(structWindowSize)
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_GETMINRECT    hwnd:" & wParam & vbNewLine
            Form2.Text1.Text = Form2.Text1.Text & "                     TOP:" & Hex$(structWindowSize.Top) & vbNewLine
            Form2.Text1.Text = Form2.Text1.Text & "                     LEFT:" & Hex$(structWindowSize.Left) & vbNewLine
            Form2.Text1.Text = Form2.Text1.Text & "                     HEIGHT:" & Hex$(structWindowSize.Right) & vbNewLine
            Form2.Text1.Text = Form2.Text1.Text & "                     WIDTH:" & Hex$(structWindowSize.Bottom) & vbNewLine
        Case HSHELL_REDRAW
            'wParam == Handle to the redrawn window
            'lParam == The value is TRUE if the window is flashing, or FALSE otherwise
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_REDRAW    hwnd:" & wParam & "    Flashing:" & CBool(lParam) & vbNewLine
        Case HSHELL_TASKMAN
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_TASKMAN" & vbNewLine
        Case HSHELL_LANGUAGE
            'wParam == Handle to the window
            'lParam == Handle to a keyboard layout
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_LANGUAGE    hwnd:" & wParam & "    Keybd Handle:" & lParam & vbNewLine
        Case HSHELL_ACCESSIBILITYSTATE
            'wParam == ACCESS_FILTERKEYS, ACCESS_MOUSEKEYS, or ACCESS_STICKYKEYS
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_ACCESSIBILITYSTATE    wParam:"
            If wParam = ACCESS_FILTERKEYS Then
                 Form2.Text1.Text = Form2.Text1.Text & "FILTERKEYS" & vbNewLine
            ElseIf wParam = ACCESS_MOUSEKEYS Then
                 Form2.Text1.Text = Form2.Text1.Text & "MOUSEKEYS" & vbNewLine
            ElseIf wParam = ACCESS_STICKYKEYS Then
                 Form2.Text1.Text = Form2.Text1.Text & "STICKYKEYS" & vbNewLine
            End If
        Case HSHELL_APPCOMMAND
            'wParam == Windows 2000: Where the WM_APPCOMMAND message was originally sent
            'lParam == application command corresponding to the input event
            Form2.Text1.Text = Form2.Text1.Text & "HSHELL_APPCOMMAND    Destination:" & wParam & "    APP_CMD:" & lParam & vbNewLine
            
            'Since we handle this message we should prevent it from being handled elsewhere
            ShellProc = True
            Exit Function
    End Select
    
    ShellProc = CallNextHookEx(hHook, uCode, wParam, lParam)
End Function




'-----------------------------
' SET DEBUG FILTER HOOK
'-----------------------------
Public Sub SetDebugHook()
    If IsDBGHooked Then
        MsgBox "Don't hook DEBUG twice or you will be unable to unhook it."
    Else
        hHookDBG = SetWindowsHookEx(WH_DEBUG, AddressOf DebugProc, 0, App.ThreadID)
        IsDBGHooked = True
    End If
End Sub

Public Sub RemoveDebugHook()
    Dim temp As Long
    temp = UnhookWindowsHookEx(hHookDBG)
    IsDBGHooked = False
End Sub


Public Function DebugProc(ByVal uCode As Long, ByVal wParam As Long, lParam As DEBUGHOOKINFO) As Long
    If uCode >= 0 Then
        Select Case wParam
            Case WH_JOURNALPLAYBACK
    '        This will fire too many times to be of use
    '        Why does this fire - no journal hook has been installed -- Determine why ???
            Case WH_SHELL
                Form2.Text1.Text = Form2.Text1.Text & "WH_SHELL    CODE:" & lParam.code & "    WPARAM:" & lParam.wParam & "    LPARAM:" & lParam.lParam & vbNewLine
                DoEvents
        End Select
    End If
            
    'To prevent the system from calling the hook, the hook procedure must return a nonzero value
    DebugProc = CallNextHookEx(hHookDBG, uCode, wParam, lParam)
End Function
